#version 330
#extension GL_EXT_gpu_shader4 : enable
//Amorphous Rainbow BlobMod01.fsh  by   brejep
//https://www.shadertoy.com/view/lsKGDz
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


vec3 a = vec3(0.5, 0.5, 0.5);
vec3 b = vec3(0.5, 0.5, 0.5);
vec3 c = vec3(1.0, 1.0, 1.0);
vec3 d = vec3(0.0, 0.33, 0.67);

vec3 palette(in float val, vec3 u, vec3 v, vec3 w, vec3 x) {
    return u + v * cos( 6.28318531 * (w * (val + x)));
}

float map(in vec3 p) {
    vec3 q = mod(p+2.0, 4.0) - 2.0;
	float d0 = length(q) - 1.0;
    d0 += 0.1 * sin(10.0 * p.x) * sin(10.0 * p.y + 10.0 * iTime) * sin(10.0 * p.z);
    float d1 = p.y + 1.0;
    
    float k = 1.225;
    float h = clamp(0.5 + 0.5 * (d0 - d1)/k, 0.0, 1.0);
    return mix(d0, d1, h) - k * h * (1.0 -h);
}

vec3 calcNormal( in vec3 p ) {
    vec2 e = vec2(0.0001, 0.0);
    
	return normalize( vec3( 
        map(p+e.xyy) - map(p-e.xyy),
        map(p+e.yxy) - map(p-e.yxy),
        map(p+e.yyx) - map(p-e.yyx)
    ));
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = (2.0*gl_FragCoord.xy-iResolution.xy) / iResolution.y;
    
    vec3 rayOrigin = vec3(0.0, 0.0, 2.0);
    vec3 rayDirection = normalize(vec3(uv, -1.0));
    
    vec3 col = vec3(0.22);
    
    float h = 1.0;
    float t = 0.0;
    float tmax = 20.0;
    
    for(int i = 0; i<100; i++) {
        if(h < 0.0001 || t > tmax) { break; }
     	h = map(rayOrigin + t * rayDirection);
        t += h;
    }
    
    vec3 lig = vec3(0.5773);
    if(t < tmax) {
        vec3 pos = rayOrigin + t * rayDirection;
        vec3 norm = calcNormal(pos);
        col = vec3(0.98); // background colour
        // lighting
        col = palette(t, vec3(0.5), vec3(0.5), vec3(1.0), vec3(0.0, 0.33, 0.67)) * clamp(dot(norm, lig), 0.0, 1.0);
        col += vec3(0.2, 0.3, 0.4) * clamp(norm.y, 0.0, 1.0);
       	col += vec3(1.0, 0.7, 0.2) * clamp(1.0 + dot(rayDirection, norm), 0.0, 1.0);
        col *= 0.8;
        //fog
        col *= exp(-0.1 * t);
    }
    
	gl_FragColor = vec4(col, 1.0);
}
